//----------------------------------------------------------
// Copyright (C) Microsoft Corporation. All rights reserved.
//----------------------------------------------------------
var __extends=this.__extends||function(b,c){function a(){this.constructor=b}a.prototype=c.prototype;b.prototype=new a};define(["require","exports","Presentation/Scripts/TFS/TFS","Presentation/Scripts/TFS/TFS.Core","Presentation/Scripts/TFS/TFS.UI.Controls","Presentation/TestScripts/Resources/TFS.Resources.Presentation"],function(u,c,t,s,q,p){var g=t,d=s,b=q,r=p,e=d.delegate,a=function(c){__extends(a,c);function a(d){c.call(this,d);if(this.getType()===a)throw new Error("You cannot instantiate an abstract type.");this.instanceId="val_"+b.getId()}a.optionsPrefix="validator";a.EVENT_VALIDATE="validate";a.EVENT_VALIDATE_STATUS="validate-status";a.prototype.initializeOptions=function(a){c.prototype.initializeOptions.call(this,$.extend({invalidCssClass:"invalid",message:"Invalid input value!",group:"*",allowEmptyString:false},a))};a.prototype.initialize=function(){c.prototype.initialize.call(this);this._bind("change",e(this,this.onChanged));this._bind(window.document.body,a.EVENT_VALIDATE,e(this,this.onValidationRequired),true);this._options.bindtokeystrokes&&this._bind("keyup",e(this,this.onKeyUp))};a.prototype.getValue=function(){return this._element.val()};a.prototype.isValid=function(){return true};a.prototype.getValidationGroup=function(){return this._options.group};a.prototype.getMessage=function(){var a=this._options.message;if(a)if($.isFunction(a))a=a.call(this);return a};a.prototype.onKeyUp=function(){this.validate()};a.prototype.onChanged=function(){this.validate()};a.prototype.onValidationRequired=function(b,a){(!a||a==="*"||a===this._options.group)&&this.validate()};a.prototype.validate=function(){var b,c;if(!this._disposed){b=this._testEmptyString()||this.isValid();c=this.getValidationGroup();this._element.toggleClass(this._options.invalidCssClass,!b);this._fire(a.EVENT_VALIDATE_STATUS,[this,c,b])}};a.prototype._testEmptyString=function(){return this._options.allowEmptyString&&this.getValue()===""};return a}(b.Enhancement);c.BaseValidator=a;g.initClassPrototype(a,{instanceId:null});var j=function(b){__extends(a,b);function a(a){b.call(this,a)}a.optionsPrefix="requiredValidator";a.prototype.initializeOptions=function(a){b.prototype.initializeOptions.call(this,$.extend({message:"Input value cannot be empty!"},a))};a.prototype.isValid=function(){return $.trim(this.getValue())?true:false};return a}(a);c.RequiredValidator=j;b.Enhancement.registerEnhancement(j,".validate.required");var l=function(b){__extends(a,b);function a(a){b.call(this,a)}a.optionsPrefix="rangeValidator";a.prototype.initializeOptions=function(a){b.prototype.initializeOptions.call(this,$.extend({message:"Out of range"},a))};a.prototype.isValid=function(){var a=this.getValue(),c=this._element.data("rangeValidator-min"),b=this._element.data("rangeValidator-max");return a>=c&&a<=b};a.prototype.getMessage=function(){var c=this.getValue(),b=this._element.data("rangeValidator-min"),a=this._element.data("rangeValidator-max");return c<b?"Input cannot be smaller than "+b:c>a?"Input cannot be greater than "+a:void 0};return a}(a);c.RangeValidator=l;b.Enhancement.registerEnhancement(l,".validate.range");var m=function(b){__extends(a,b);function a(a){b.call(this,a)}a.optionsPrefix="regexValidator";a.prototype.initializeOptions=function(a){b.prototype.initializeOptions.call(this,$.extend({message:"Input value doesn't match regex",testEmptyString:true},a))};a.prototype.isValid=function(){var b,a;a=this._options.regex||this._element.data("regexValidator-regex");if(a){b=this.getValue();if(this._options.testEmptyString||$.trim(b))return new RegExp(a).test(b)}return true};a.prototype.getMessage=function(){return this._element.data("regexValidator-message")||this._options.message};return a}(a);c.RegexValidator=m;b.Enhancement.registerEnhancement(m,".validate.regex");var k=function(b){__extends(a,b);function a(a){b.call(this,a)}a.optionsPrefix="customValidator";a.prototype.initializeOptions=function(a){b.prototype.initializeOptions.call(this,$.extend({message:"Input value doesn't satisfy function",testEmptyString:true,validate:function(){return true}},a))};a.prototype.isValid=function(){var b,a;a=this._options.validate;if(a){b=this.getValue();if(this._options.testEmptyString||$.trim(b))return a(b)}return true};a.prototype.setValidate=function(a){this._options.validate=a};a.prototype.getMessage=function(){return this._element.data("customValidator-message")||this._options.message};return a}(a);c.CustomValidator=k;b.Enhancement.registerEnhancement(k,".validate.custom");var n=function(b){__extends(a,b);function a(a){b.call(this,a)}a.optionsPrefix="dateValidator";a.prototype.initializeOptions=function(a){b.prototype.initializeOptions.call(this,$.extend({message:"Input value must be a valid date",parseFormat:""},a))};a.prototype.isValid=function(){var b=$.trim(this.getValue()),a;if(b)a=d.DateUtils.parseLocale(b,this._options.parseFormat);else return true;return a instanceof Date&&!isNaN(a)};a.prototype.getMessage=function(){return this._element.data("dateValidator-message")||this._options.message};return a}(a);c.DateValidator=n;b.Enhancement.registerEnhancement(n,".validate.date");var h=function(b){__extends(a,b);function a(a){b.call(this,a)}a.optionsPrefix="integerRangeValidator";a.prototype.isValid=function(){var g=this.getValue(),b=d.NumberUtils.parseLocale(g),e=false,a=parseInt(""+b,10),f=parseFloat(""+b),c;if(!isNaN(b)&&a===f&&isFinite(a)){c=this._getBounds();if(c.min<=a&&c.max>=a)e=true}return e};a.prototype.getMessage=function(){var a=this._getBounds();return d.StringUtils.format(r.Validation_IntegerRange,a.min,a.max)};a.prototype._getBounds=function(){var b,a;b=this._options.minValue!==undefined?this._options.minValue:Number(this._element.data("integerRangeValidator-min"));a=this._options.maxValue!==undefined?this._options.maxValue:Number(this._element.data("integerRangeValidator-max"));return{min:b,max:a}};return a}(a);c.IntegerRangeValidator=h;b.Enhancement.registerEnhancement(h,".validate.integerRange");var i=function(b){__extends(a,b);function a(a){b.call(this,a)}a.optionsPrefix="maxLengthValidator";a.prototype.initializeOptions=function(a){b.prototype.initializeOptions.call(this,$.extend({message:d.StringUtils.format("Input cannot exceed {0} characters.",a.maxLength)},a))};a.prototype.isValid=function(){return this.getValue().length>this._options.maxLength?false:true};return a}(a);c.MaxLengthValidator=i;b.Enhancement.registerEnhancement(i,".validate.maxlength");var f=function(c){__extends(b,c);function b(a){c.call(this,a);this._messages={}}b.prototype.initializeOptions=function(a){c.prototype.initializeOptions.call(this,$.extend({coreCssClass:"validation-summary",group:"*"},a))};b.prototype.initialize=function(){c.prototype.initialize.call(this);this._bind(this._options.context||window.document.body,a.EVENT_VALIDATE_STATUS,e(this,this.onValidationStatus),true)};b.prototype.onValidationStatus=function(d,a,b,c){delete this._messages[a.instanceId];if(!b||b==="*"||b===this._options.group){if(!c)this._messages[a.instanceId]=a.getMessage();this._updateUI()}};b.prototype.validate=function(){try{this._messages={};this._ignoreUIUpdate=true;this._fire(this._options.context||window.document.body,a.EVENT_VALIDATE,[this._options.group])}finally{this._ignoreUIUpdate=false}this._updateUI()};b.prototype._updateUI=function(){var b=this,a=false;if(!this._ignoreUIUpdate){this._element.empty();$.each(this._messages,function(d,c){a=true;b._element.append($("<div />").text(c||""))});this._element.toggleClass("invalid",a)}};return b}(b.BaseControl);c.ValidationSummary=f;g.initClassPrototype(f,{_messages:null,_ignoreUIUpdate:false});b.Enhancement.registerEnhancement(f,".validation-summary");function o(f,d,c){var b=[];function e(e,c,a,d){if(!a||a==="*"||a===f)!d&&b.push(c)}$(c||window.document.body).bind(a.EVENT_VALIDATE_STATUS,e);$(c||window.document.body).trigger(a.EVENT_VALIDATE,[f]);$(c||window.document.body).unbind(a.EVENT_VALIDATE_STATUS,e);b.length&&d&&$.each(b,function(b,a){d.push(a)});return b.length===0}c.validateGroup=o;g.tfsModuleLoaded("TFS.UI.Controls.Validation",c)});
// SIG // Begin signature block
// SIG // MIIbGwYJKoZIhvcNAQcCoIIbDDCCGwgCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFJKLt3BIUX2i
// SIG // El6kKv4A7YxUPqQ0oIIVgjCCBMMwggOroAMCAQICEzMA
// SIG // AABxsy6Ka4KqH04AAAAAAHEwDQYJKoZIhvcNAQEFBQAw
// SIG // dzELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBMB4XDTE1MDMyMDE3
// SIG // MzIwM1oXDTE2MDYyMDE3MzIwM1owgbMxCzAJBgNVBAYT
// SIG // AlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQH
// SIG // EwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29y
// SIG // cG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsT
// SIG // Hm5DaXBoZXIgRFNFIEVTTjpCOEVDLTMwQTQtNzE0NDEl
// SIG // MCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3RhbXAgU2Vy
// SIG // dmljZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBAOqRvbKI/RRvITYoA2YzOmYI+1tLpKugKDRKQzII
// SIG // wIblyT3VJbx7PmKH1n3vD3RTo/GRY4h0f+gkzQNQxfHK
// SIG // ABZ7pTmwBhw8RH7568SygbwXI7r9ZTgZhX/KoCn99jrA
// SIG // Cy9o9OA0Tn1vF8Bumar6f2El0SZw0nR932FzXM5UKjlR
// SIG // AzMJ+FCteMeJCLbUhSo/19gfUerv/GhetcHnB2gyjS9y
// SIG // Uf4DMUdRxdLrcgevIJX42mr4d2fkYJpwTKtFy34Ir+WB
// SIG // 1FfPOswTdZ0mzaCiaVC8OoiU37BUON6JOc2GMqWQD36/
// SIG // 7cyUJaZBhmEmx903flwN6BfKN3/oJLZOtPgbI+sCAwEA
// SIG // AaOCAQkwggEFMB0GA1UdDgQWBBT4/SOHBZSAVs0zpUHC
// SIG // bMwINsiyojAfBgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7
// SIG // syuwwzWzDzBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9NaWNyb3NvZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsG
// SIG // AQUFBwEBBEwwSjBIBggrBgEFBQcwAoY8aHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsG
// SIG // AQUFBwMIMA0GCSqGSIb3DQEBBQUAA4IBAQAtBLTKKQtZ
// SIG // /C7qoK9MTmgE+JLtKcJmzGtwyYfovof8XfTdT6Uab3iX
// SIG // rWsFOFFBcp055Bobw21x/HC208y2kFgEKD/WHu+DsxQY
// SIG // DJUL96URE5jGhVZe7jO0DDe1gOr1EmjZLnuGCHI7FHvU
// SIG // 2dAWT8AvCx8tyuUb0K7phLCPC11zuBaBQCNYLOphqv69
// SIG // f9ONWnD8ec1mlmVjtQUSduIqOyvtgqya7CdBp5cOIxaf
// SIG // QchObVMRQATMYJnamOwrrpf74H31uosA9CUXf2J6u1FX
// SIG // wfDwzZwbYXOtlYwrdiKoq3A4tAEofWZCU96f9Ad8WjAO
// SIG // ggNZ9oSGuRUlYrAL0s/x25ZFMIIE7DCCA9SgAwIBAgIT
// SIG // MwAAAQosea7XeXumrAABAAABCjANBgkqhkiG9w0BAQUF
// SIG // ADB5MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGlu
// SIG // Z3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMV
// SIG // TWljcm9zb2Z0IENvcnBvcmF0aW9uMSMwIQYDVQQDExpN
// SIG // aWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQTAeFw0xNTA2
// SIG // MDQxNzQyNDVaFw0xNjA5MDQxNzQyNDVaMIGDMQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYD
// SIG // VQQDExVNaWNyb3NvZnQgQ29ycG9yYXRpb24wggEiMA0G
// SIG // CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCS/G82u+ED
// SIG // uSjWRtGiYbqlRvtjFj4u+UfSx+ztx5mxJlF1vdrMDwYU
// SIG // EaRsGZ7AX01UieRNUNiNzaFhpXcTmhyn7Q1096dWeego
// SIG // 91PSsXpj4PWUl7fs2Uf4bD3zJYizvArFBKeOfIVIdhxh
// SIG // RqoZxHpii8HCNar7WG/FYwuTSTCBG3vff3xPtEdtX3gc
// SIG // r7b3lhNS77nRTTnlc95ITjwUqpcNOcyLUeFc0Tvwjmfq
// SIG // MGCpTVqdQ73bI7rAD9dLEJ2cTfBRooSq5JynPdaj7woY
// SIG // SKj6sU6lmA5Lv/AU8wDIsEjWW/4414kRLQW6QwJPIgCW
// SIG // Ja19NW6EaKsgGDgo/hyiELGlAgMBAAGjggFgMIIBXDAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDAzAdBgNVHQ4EFgQUif4K
// SIG // MeomzeZtx5GRuZSMohhhNzQwUQYDVR0RBEowSKRGMEQx
// SIG // DTALBgNVBAsTBE1PUFIxMzAxBgNVBAUTKjMxNTk1KzA0
// SIG // MDc5MzUwLTE2ZmEtNGM2MC1iNmJmLTlkMmIxY2QwNTk4
// SIG // NDAfBgNVHSMEGDAWgBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3JsLm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWND
// SIG // b2RTaWdQQ0FfMDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUH
// SIG // AQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNpZ1BD
// SIG // QV8wOC0zMS0yMDEwLmNydDANBgkqhkiG9w0BAQUFAAOC
// SIG // AQEApqhTkd87Af5hXQZa62bwDNj32YTTAFEOENGk0Rco
// SIG // 54wzOCvYQ8YDi3XrM5L0qeJn/QLbpR1OQ0VdG0nj4E8W
// SIG // 8H6P8IgRyoKtpPumqV/1l2DIe8S/fJtp7R+CwfHNjnhL
// SIG // YvXXDRzXUxLWllLvNb0ZjqBAk6EKpS0WnMJGdAjr2/TY
// SIG // pUk2VBIRVQOzexb7R/77aPzARVziPxJ5M6LvgsXeQBkH
// SIG // 7hXFCptZBUGp0JeegZ4DW/xK4xouBaxQRy+M+nnYHiD4
// SIG // BfspaxgU+nIEtwunmmTsEV1PRUmNKRot+9C2CVNfNJTg
// SIG // FsS56nM16Ffv4esWwxjHBrM7z2GE4rZEiZSjhjCCBbww
// SIG // ggOkoAMCAQICCmEzJhoAAAAAADEwDQYJKoZIhvcNAQEF
// SIG // BQAwXzETMBEGCgmSJomT8ixkARkWA2NvbTEZMBcGCgmS
// SIG // JomT8ixkARkWCW1pY3Jvc29mdDEtMCsGA1UEAxMkTWlj
// SIG // cm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5
// SIG // MB4XDTEwMDgzMTIyMTkzMloXDTIwMDgzMTIyMjkzMlow
// SIG // eTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWlj
// SIG // cm9zb2Z0IENvZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqG
// SIG // SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCycllcGTBkvx2a
// SIG // YCAgQpl2U2w+G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/
// SIG // 3sJCTiPVcgDbNVcKicquIEn08GisTUuNpb15S3GbRwfa
// SIG // /SXfnXWIz6pzRH/XgdvzvfI2pMlcRdyvrT3gKGiXGqel
// SIG // cnNW8ReU5P01lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJp
// SIG // L9oZC/6SdCnidi9U3RQwWfjSjWL9y8lfRjFQuScT5EAw
// SIG // z3IpECgixzdOPaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn
// SIG // 0i1i8UU956wIAPZGoZ7RW4wmU+h6qkryRs83PDietHdc
// SIG // pReejcsRj1Y8wawJXwPTAgMBAAGjggFeMIIBWjAPBgNV
// SIG // HRMBAf8EBTADAQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJ
// SIG // Ny4zFha5TJoKHzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGC
// SIG // NxUBBAUCAwEAATAjBgkrBgEEAYI3FQIEFgQU/dExTtMm
// SIG // ipXhmGA7qDFvpjy82C0wGQYJKwYBBAGCNxQCBAweCgBT
// SIG // AHUAYgBDAEEwHwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8
// SIG // KuEKU5VZ5KQwUAYDVR0fBEkwRzBFoEOgQYY/aHR0cDov
// SIG // L2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVj
// SIG // dHMvbWljcm9zb2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUF
// SIG // BwEBBEgwRjBEBggrBgEFBQcwAoY4aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRS
// SIG // b290Q2VydC5jcnQwDQYJKoZIhvcNAQEFBQADggIBAFk5
// SIG // Pn8mRq/rb0CxMrVq6w4vbqhJ9+tfde1MOy3XQ60L/svp
// SIG // LTGjI8x8UJiAIV2sPS9MuqKoVpzjcLu4tPh5tUly9z7q
// SIG // QX/K4QwXaculnCAt+gtQxFbNLeNK0rxw56gNogOlVuC4
// SIG // iktX8pVCnPHz7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y
// SIG // 4k74jKHK6BOlkU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wd
// SIG // zaKMvSeyeWNWRKJRzfnpo1hW3ZsCRUQvX/TartSCMm78
// SIG // pJUT5Otp56miLL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q7
// SIG // 0eFW6NB4lhhcyTUWX92THUmOLb6tNEQc7hAVGgBd3TVb
// SIG // Ic6YxwnuhQ6MT20OE049fClInHLR82zKwexwo1eSV32U
// SIG // jaAbSANa98+jZwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKN
// SIG // MxZlHg6K3RDeZPRvzkbU0xfpecQEtNP7LN8fip6sCvsT
// SIG // J0Ct5PnhqX9GuwdgR2VgQE6wQuxO7bN2edgKNAltHIAx
// SIG // H+IOVN3lofvlRxCtZJj/UBYufL8FIXrilUEnacOTj5XJ
// SIG // jdibIa4NXJzwoq6GaIMMai27dmsAHZat8hZ79haDJLmI
// SIG // z2qoRzEvmtzjcT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq
// SIG // /2mbluIQqBC0N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZo
// SIG // NAAAAAAAHDANBgkqhkiG9w0BAQUFADBfMRMwEQYKCZIm
// SIG // iZPyLGQBGRYDY29tMRkwFwYKCZImiZPyLGQBGRYJbWlj
// SIG // cm9zb2Z0MS0wKwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBD
// SIG // ZXJ0aWZpY2F0ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1
// SIG // MzA5WhcNMjEwNDAzMTMwMzA5WjB3MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSEwHwYDVQQDExhNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBQQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCfoWyx39tIkip8ay4Z4b3i48WZUSNQrc7d
// SIG // GE4kD+7Rp9FMrXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr
// SIG // 6Hu97IkHD/cOBJjwicwfyzMkh53y9GccLPx754gd6udO
// SIG // o6HBI1PKjfpFzwnQXq/QsEIEovmmbJNn1yjcRlOwhtDl
// SIG // KEYuJ6yGT1VSDOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd+
// SIG // +NIT8wi3U21StEWQn0gASkdmEScpZqiX5NMGgUqi+YSn
// SIG // EUcUCYKfhO1VeP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68e
// SIG // eEExd8yb3zuDk6FhArUdDbH895uyAc4iS1T/+QXDwiAL
// SIG // AgMBAAGjggGrMIIBpzAPBgNVHRMBAf8EBTADAQH/MB0G
// SIG // A1UdDgQWBBQjNPjZUkZwCu1A+3b7syuwwzWzDzALBgNV
// SIG // HQ8EBAMCAYYwEAYJKwYBBAGCNxUBBAMCAQAwgZgGA1Ud
// SIG // IwSBkDCBjYAUDqyCYEBWJ5flJRP8KuEKU5VZ5KShY6Rh
// SIG // MF8xEzARBgoJkiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJ
// SIG // k/IsZAEZFgltaWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jv
// SIG // c29mdCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eYIQ
// SIG // ea0WoUqgpa1Mc1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BB
// SIG // hj9odHRwOi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2Ny
// SIG // bC9wcm9kdWN0cy9taWNyb3NvZnRyb290Y2VydC5jcmww
// SIG // VAYIKwYBBQUHAQEESDBGMEQGCCsGAQUFBzAChjhodHRw
// SIG // Oi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01p
// SIG // Y3Jvc29mdFJvb3RDZXJ0LmNydDATBgNVHSUEDDAKBggr
// SIG // BgEFBQcDCDANBgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wD
// SIG // RDbd6bStd9vOeVFNAbEudHFbbQwTq86+e4+4LtQSooxt
// SIG // YrhXAstOIBNQmd16QOJXu69YmhzhHQGGrLt48ovQ7DsB
// SIG // 7uK+jwoFyI1I4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mR
// SIG // KiQicPv2/OR4mS4N9wficLwYTp2OawpylbihOZxnLcVR
// SIG // DupiXD8WmIsgP+IHGjL5zDFKdjE9K3ILyOpwPf+FChPf
// SIG // wgphjvDXuBfrTot/xTUrXqO/67x9C0J71FNyIe4wyrt4
// SIG // ZVxbARcKFA7S2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGys
// SIG // OUzU9nm/qhh6YinvopspNAZ3GmLJPR5tH4LwC8csu89D
// SIG // s+X57H2146SodDW4TsVxIxImdgs8UoxxWkZDFLyzs7BN
// SIG // Z8ifQv+AeSGAnhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU
// SIG // 2DKATCYqSCRfWupW76bemZ3KOm+9gSd0BhHudiG/m4LB
// SIG // J1S2sWo9iaF2YbRuoROmv6pH8BJv/YoybLL+31HIjCPJ
// SIG // Zr2dHYcSZAI9La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCl
// SIG // eKuzoJZ1GtmShxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/J
// SIG // mu5J4PcBZW+JC33Iacjmbuqnl84xKf8OxVtc2E0bodj6
// SIG // L54/LlUWa8kTo/0xggUFMIIFAQIBATCBkDB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQQITMwAAAQosea7XeXumrAAB
// SIG // AAABCjAJBgUrDgMCGgUAoIIBHTAZBgkqhkiG9w0BCQMx
// SIG // DAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4wDAYK
// SIG // KwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQU9WUwOsk2
// SIG // 3oLW7fqhWTGE7Sa8UF4wgbwGCisGAQQBgjcCAQwxga0w
// SIG // gaqggY+AgYwAVABGAFMALgBVAEkALgBDAG8AbgB0AHIA
// SIG // bwBsAHMALgBWAGEAbABpAGQAYQB0AGkAbwBuAC4AbQBp
// SIG // AG4AXwA5AGYAMgA1ADIAZAA5ADAALQBkADAANgAyAC0A
// SIG // NABjAGYANQAtAGIAZQA0ADMALQBiADIANAA4AGQAYgA1
// SIG // ADYAOAAwAGYAYgAuAGoAc6EWgBRodHRwOi8vbWljcm9z
// SIG // b2Z0LmNvbTANBgkqhkiG9w0BAQEFAASCAQCIkdSnzrZF
// SIG // le/AaxkLeXyF1Br91Pc7ya88nkMQ7/awEhq+DwcOtVfm
// SIG // RMlpGsCFTS1LmlwnFZYcaDLRm9hcJk5wY3xT3X6TMbf4
// SIG // HS7XoYbyGTtcvmqieXqotgZxotcxTI0wQFec11ITRmV5
// SIG // UrT/XrM8yPWY8By94/iBtafJNUR8lZjWcTNa2FkePLVY
// SIG // 5Dos8yPGZiHACQRTgqKB1hDtDEciM6ZqyA5FolC2OZYs
// SIG // Nchx+9tK6BpGf/rveZkbD13JhxAb6lL8JfmPYG80wHH2
// SIG // nkjYGpebhtahZ6NKweF22whBUjTax7UCkC56RGX6+Q8A
// SIG // 1E2FbVlnO8w/FvGX1qRxcGFRoYICKDCCAiQGCSqGSIb3
// SIG // DQEJBjGCAhUwggIRAgEBMIGOMHcxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdS
// SIG // ZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9y
// SIG // YXRpb24xITAfBgNVBAMTGE1pY3Jvc29mdCBUaW1lLVN0
// SIG // YW1wIFBDQQITMwAAAHGzLoprgqofTgAAAAAAcTAJBgUr
// SIG // DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEH
// SIG // ATAcBgkqhkiG9w0BCQUxDxcNMTUwNjI5MDQzNDMwWjAj
// SIG // BgkqhkiG9w0BCQQxFgQUCrt0WXnEKA2qnkVNnxE+0KaT
// SIG // 42IwDQYJKoZIhvcNAQEFBQAEggEAHsh5/oS1sSgX6bd+
// SIG // 4ny/LnxSBZoA8qSphZ8oKF8ch84LhBfdrLuaBNVJoLwo
// SIG // qkc+R1m6Qhto/dsHRAQjp+BnvVebwjnQ7JEZgt0Mhl0h
// SIG // 0LJUXbnL2nkGUiC/tAVhFuibRfUS4yNqRgvGa4PBljZf
// SIG // V6PSZASdFzXeH734wSsSCjjhRHKYsgW3fjc046cwVp2R
// SIG // g3s5NwK9Kzfvzke/FUTdZWwf0Dn3yL4D8YkyGIT/3y0C
// SIG // Q5cMdMxtJWN9QycD5HmsbdKfkquCvAkt+AMWwdlFHSF7
// SIG // gX2Vl6jKaDgdqXrhC9mGGHvTJ+i3f84BpxBYD3NIl53a
// SIG // ULTxbzQ3HaU7DxKXKA==
// SIG // End signature block
